function[fc,SIM_final,c_c]=Clustering(x,fs,W,parm,H,patron)

%% Calculo Roll-Off

           N_r=2^nextpow2(length(x));
           X=abs(fft(x,N_r)); 
           X_PSD=X.^2; % Se calcula la densidad espectral de potencia.
           
           %El calculo de la energa total se obtenien a travs de la
           %frecuencia de Nyquist o fs/2. 
           X1=(X_PSD(1:N_r/2));
           total_energy=sum(X1);
           
           % Se establece el umbral a un 85% de la energa total.
           umbral=0.85*total_energy;
           aux=0;
           % Se itera sumando los valores de la PSD hasta alcanzar el
           % umbral.
           for l=1:length(X_PSD)
               aux=aux+X_PSD(l);
               if aux>=umbral
               fc=l*fs/N_r; %Frecuencia de roll-off
               break;
               end
               
           end


%% Calculo distancia coseno
          
              if parm==512
                  load (['../Datos/Bases/W_64_4.mat']);
              elseif parm==1024
                  load (['../Datos/Bases/W_128_4.mat']);
              else 
                  load (['../Datos/Bases/W_256_4.mat']);
              end
          

          [ncol,nfil]=size(W1_1);
          SIM=zeros(nfil,1);
          for m1=1:nfil
              SIM(m1)=(W(1:ncol,1)'*W1_1(:,m1))/(norm(W(1:ncol,1))*norm(W1_1(:,m1)));
          end
          SIM_final=max(SIM);
          
          
%% Correlacin entre la matriz de activaciones obtenidas en la
%% descomposicin y el patron generado
         
          % Preprocesamos el valor de la matriz de activaciones H(i,:), para que
          % sus valores se encuentren en el mismo rango que los del patrn,
          % [0,1].
          aux1=H/max(H);
          aux1(aux1>mean(aux1))=1;
          aux1(aux1<mean(aux1))=0;
          
          % Se calcula el coeficiente de correlacin.
          if length(aux1)==length(patron)
          [r]=corrcoef(aux1,patron);
          % Se extrae el valor del coeficiente de correlacin.
          c_c=r(1,2);
          else
          c_c=1;
          end
          

end